//
//  SubForm01ViewController.m
//  iOS SDK Sample
//
//  Created by NEI アプリGr on 2013/06/18.
//  Copyright (c) 2013年 Nippon Primex Inc. All rights reserved.
//

#import "SubForm01ViewController.h"

@interface SubForm01ViewController ()

@end

@implementation SubForm01ViewController

@synthesize objLib = mObjLib;
@synthesize strPrtName = mStrPrtName;
@synthesize sclView = mSclView;

-(void) btnViewSetting : (UIButton *) btnObj
{
    NSString* osversion = [UIDevice currentDevice].systemVersion;
    NSArray* a = [osversion componentsSeparatedByString:@"."];
    
    if([(NSString*)[a objectAtIndex:0] intValue] >= 7)
    {
        btnObj.layer.borderColor = [UIColor blueColor].CGColor;
        btnObj.layer.borderWidth = 1.0f;
        btnObj.layer.cornerRadius = 7.5f;
        
        btnObj.backgroundColor = [UIColor colorWithRed:0.95 green:1.0 blue:1.0 alpha:1.0];
        [btnObj setTintColor:[UIColor blackColor]];
    }
}

-(void) setReturnCode :(int) nmsResult
{
    lblReturnCode.text = [NSString stringWithFormat:@"Return Code: %d", nmsResult];
    
    if(nmsResult != 0)
    {
        lblReturnCode.textColor = [UIColor redColor];
    }
    else
    {
        lblReturnCode.textColor = [UIColor blackColor];
    }
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }

    return self;
}

-(void) appClose
{
    [mObjLib NClosePrinters];
}

-(void) viewDidLayoutSubviews
{
    int nmsWidth    = 0;
    int nmsHeight    = btnBack.frame.origin.y + btnBack.frame.size.height + 200;
    
    [mSclView setContentSize: CGSizeMake(nmsWidth, nmsHeight)];
    [mSclView flashScrollIndicators];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.

    [self btnViewSetting:btnNEnumPrinters];
    [self btnViewSetting:btnNGetPrinterFromID];
    [self btnViewSetting:btnNDeletePrinter];
    [self btnViewSetting:btnNRenamePrinter];
    [self btnViewSetting:btnNGetPrinterInf];
    [self btnViewSetting:btnBack];
    
    txtNEnumPrinters.delegate = self;
    txtSerialID.delegate = self;
    txtPrtDeleteName.delegate = self;
    txtPrtBeforeName.delegate = self;
    txtPrtAfterName.delegate = self;
    
    txtGetPrtName.delegate = self;
    txtPrtInfResult.delegate = self;
    
    // App close setting(Enter backgroud)
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(appClose)
                                                 name:UIApplicationDidEnterBackgroundNotification object:nil];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(BOOL)textFieldShouldReturn:(UITextField*) textField {
    [textField resignFirstResponder];
    return YES;
}

- (IBAction)pushBtnNEnumPrinters:(UIButton *)sender
{
    int nmsResult = 0;
    NSMutableString* strPrtName = [NSMutableString string];
    int o_size = 0;
    
    // comment:NPI NEnumPrinters
    nmsResult = [mObjLib NEnumPrinters:strPrtName:&o_size];
    
    txtNEnumPrinters.text = strPrtName;
    
    [self setReturnCode:nmsResult];
}


- (IBAction)pushBtnNGetPrinterFromID:(UIButton *)sender
{
    int nmsResult = 0;
    NSMutableString* o_printer = [NSMutableString string];
    
    // comment:NPI NDeletePrinter
    nmsResult = [mObjLib NGetPrinterFromID:[txtSerialID text] : o_printer];
    
    txtPrtNameFromID.text = o_printer;
    
    [self setReturnCode:nmsResult];
    
}

- (IBAction)pushBtnNDeletePrinter:(UIButton *)sender
{
    int nmsResult = 0;
    
    // comment:NPI NDeletePrinter
    nmsResult = [mObjLib NDeletePrinter:[txtPrtDeleteName text]];
    
    [self setReturnCode:nmsResult];
}


- (IBAction)pushBtnNRenamePrinter:(UIButton *)sender
{
    int nmsResult = 0;
    
    // comment:NPI NRenamePrinter
    nmsResult = [mObjLib NRenamePrinter:[txtPrtBeforeName text] : [txtPrtAfterName text]];
    
    [self setReturnCode:nmsResult];
}

- (IBAction)pushBtnNGetPrinterInf:(UIButton *)sender
{
    int nmsResult = 0;
    NSMutableString* o_ports = [NSMutableString string];
    int o_size = 0;
    
    // comment:NPI NGetPrinterInf
    nmsResult = [mObjLib NGetPrinterInf: [txtGetPrtName text] : o_ports : &o_size];
    
    txtPrtInfResult.text = o_ports;
    
    [self setReturnCode:nmsResult];
}



- (IBAction)pushBtnBack:(UIButton *)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}


- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    // キーボード表示・非表示時のイベント登録
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasShown:)
                                                 name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasHidden:)
                                                 name:UIKeyboardDidHideNotification object:nil];
}

- (void)viewWillDisappear:(BOOL)animated {
    // キーボード表示・非表示時のイベント削除
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)keyboardWasShown:(NSNotification *)notification {
    NSDictionary *info = [notification userInfo];
    CGSize kbSize = [[info objectForKey:UIKeyboardFrameBeginUserInfoKey] CGRectValue].size;
    
    UIEdgeInsets contentInsets = UIEdgeInsetsMake(0.0, 0.0, kbSize.height, 0.0);
    
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
    
    CGRect aRect = self.view.frame;
    aRect.size.height -= kbSize.height;
    if (_activeField != nil) {
        CGPoint scrollPoint = CGPointMake(0.0, _activeField.frame.origin.y - 30);
        [self.sclView setContentOffset:scrollPoint animated:YES];
    }
}

- (void)keyboardWasHidden:(NSNotification *)notification {
    UIEdgeInsets contentInsets = UIEdgeInsetsZero;
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
}

- (void)textFieldDidBeginEditing:(UITextField *)textField {
    _activeField = textField;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    _activeField = nil;
}

@end
